# blinker-library
Blinker library for embedded hardware. Works with Arduino, ESP8266, ESP32.  

# Why named blinker
When we learn a new embedded hardware, we usually started with the sketch **Blink**.  
We think **Blink** is the **hello world** of embedded hardware.  
We aim to build a easy learn IoT solution project, which like **Blink** a led.  
So we named this project **blinker** with this inspiration.  

# 为什么叫 blinker
当我们接触学习一个新的嵌入式硬件平台时, 我们通常是从 **Blink** 点亮一颗LED开始的。  
我们把 **Blink** 当作硬件开发第一课的 **hello world** 。  
我们期望做像 **Blink** 点亮一颗LED 那样简单的物联网解决方案。  
根据这个灵感, 我们将这个项目命名为 **blinker** 。  

# What's blinker
[blinker](https://blinker.app/) is a cross-hardware, cross-platform solution for the IoT. It provides APP, device and server support, and uses public cloud services for data transmission and storage. It can be used in smart home, data monitoring and other fields to help users build Internet of Things projects better and faster.   
  
[blinker](https://blinker.app/) 是一套跨硬件、跨平台的物联网解决方案，提供APP端、设备端、服务器端支持，使用公有云服务进行数据传输存储。可用于智能家居、数据监测等领域，可以帮助用户更好更快地搭建物联网项目。  

# Reference/参考
* [EN-英文](https://github.com/blinker-iot/blinker-doc/wiki/Blinker-Arduino-library-reference)  
* [CN-中文](https://github.com/blinker-iot/blinker-doc/wiki/Blinker-Arduino-%E5%BA%93%E4%BD%BF%E7%94%A8%E6%89%8B%E5%86%8C)  
* [CN-中文/官网](https://diandeng.tech/doc)  

# Thanks
[WebSockets](https://github.com/Links2004/arduinoWebSockets) - for Blinker to build up a websocket server  
[Adafruit_MQTT_Library](https://github.com/adafruit/Adafruit_MQTT_Library) - for Blinker to build up a mqtt client  
[ArduinoJson](https://github.com/bblanchon/ArduinoJson) - for Blinker to format Json data   
[OneButton](https://github.com/mathertel/OneButton) - for Blinker to manage button  
[painlessMesh](https://gitlab.com/painlessMesh/painlessMesh/tree/master) - for Blinker to build up a mesh network  
[Blynk](https://github.com/blynkkk/blynk-library)  

Due to frequent updates of versions, individual items may not be added in time. We hope to understand. If you find out, please let us know.

# 感谢
[WebSockets](https://github.com/Links2004/arduinoWebSockets) - Blinker 用这个库建立了一个 websocket 服务器  
[Adafruit_MQTT_Library](https://github.com/adafruit/Adafruit_MQTT_Library) - Blinker 用这个库建立了一个 MQTT 客户端  
[ArduinoJson](https://github.com/bblanchon/ArduinoJson) - Blinker 用这个库解析 Json   
[OneButton](https://github.com/mathertel/OneButton) - Blinker 用这个库管理按键  
[painlessMesh](https://gitlab.com/painlessMesh/painlessMesh/tree/master) - Blinker 用这个库建立mesh网络  
[Blynk](https://github.com/blynkkk/blynk-library)  

由于版本更新频繁，个别项目可能没有及时添加，望理解，如有发现可告知我们
